package gov.va.vamf.scheduling.direct.eligibilitychecker;

import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CalendarHelper {

    public static Map<String, Integer> dayOfWeekMap = new HashMap<String, Integer>();

    static {
        dayOfWeekMap.put("SUNDAY", Calendar.SUNDAY);
        dayOfWeekMap.put("MONDAY", Calendar.MONDAY);
        dayOfWeekMap.put("TUESDAY", Calendar.TUESDAY);
        dayOfWeekMap.put("WEDNESDAY", Calendar.WEDNESDAY);
        dayOfWeekMap.put("THURSDAY", Calendar.THURSDAY);
        dayOfWeekMap.put("FRIDAY", Calendar.FRIDAY);
        dayOfWeekMap.put("SATURDAY", Calendar.SATURDAY);
    }

    public static Calendar createCalendar(String tz, String dayOfWeek, String time) {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone(tz));

        calendar.set(Calendar.DAY_OF_WEEK, dayOfWeekMap.get(dayOfWeek.toUpperCase()) != null ?
            dayOfWeekMap.get(dayOfWeek.toUpperCase()) : Calendar.SUNDAY);
        setTime(calendar, time);

        return calendar;
    }

    private static void setTimeAmPm(Calendar c, String timeAmPm) {
        String pattern = "(\\d+):(\\d+) (.*)";
        Pattern r = Pattern.compile(pattern);
        Matcher m = r.matcher(timeAmPm);
        if(m.find()) {
            c.set(Calendar.HOUR, Integer.parseInt(m.group(1)));
            c.set(Calendar.MINUTE, Integer.parseInt(m.group(2)));
            c.set(Calendar.SECOND, 0);
            c.set(Calendar.MILLISECOND, 0);
            c.set(Calendar.AM_PM, m.group(3).equals("AM") ? Calendar.AM : Calendar.PM);
        }
    }

    private static void setTime(Calendar c, String timeMilitary) {
        String pattern = "^(\\d+):(\\d+)$";
        Pattern r = Pattern.compile(pattern);
        Matcher m = r.matcher(timeMilitary);
        if(m.find()) {
            c.set(Calendar.HOUR_OF_DAY, Integer.parseInt(m.group(1)));
            c.set(Calendar.MINUTE, Integer.parseInt(m.group(2)));
            c.set(Calendar.SECOND, 0);
            c.set(Calendar.MILLISECOND, 0);
        }
    }
}
